C ABCDEFGHIJKLMNOPQRSTUVWXYZ$0123456789+-*/=(),.
C
C                        MP  (VERSION 810614)
C                        ********************
C
C                 ***********************************
C                 * COPYRIGHT (C) 1980, R. P. BRENT *
C                 ***********************************
C
C $$                   ******  COMMENTS  ******
C
C MP IS A MULTIPLE-PRECISION FLOATING-POINT ARITHMETIC PACKAGE.
C IT IS ALMOST COMPLETELY MACHINE-INDEPENDENT, AND SHOULD
C RUN ON ANY MACHINE WITH AN ANSI STANDARD FORTRAN COMPILER
C AND SUFFICIENT MEMORY.
C
C FOR A GENERAL DESCRIPTION OF THE PHILOSOPHY AND DESIGN OF MP,
C SEE - R. P. BRENT, A FORTRAN MULTIPLE-PRECISION ARITHMETIC
C PACKAGE, ACM TRANS. MATH. SOFTWARE 4 (MARCH 1978), 57-70.
C SOME ADDITIONAL DETAILS ARE GIVEN IN THE SAME ISSUE, 71-81.
C FOR DETAILS OF THE IMPLEMENTATION, CALLING SEQUENCES ETC. SEE
C THE MP USERS GUIDE DISTRIBUTED WITH THE PACKAGE.
C
C MP IS NORMALLY DISTRIBUTED IN SIX FILES.  ALL HAVE 80 CHARACTER
C LOGICAL RECORDS AND USE ONLY THE (STANDARD FORTRAN) CHARACTERS
C APPEARING IN THE FIRST LINE ABOVE, EXCEPT FOR INEQUALITY SIGNS AND
C THE QUOTE CHARACTER IN FILE 6, AND THESE PLUS THE UNDERSCORE
C CHARACTER AND LOWER CASE LETTERS IN FILE 4 (THE MP USERS GUIDE).
C THE TAPE IS NORMALLY UNLABELLED, 9 TRACK, EBCDIC AND 8-BIT ASCII,
C FIXED LENGTH (80 CHARACTER) LOGICAL RECORDS (NO CR LF),
C BLOCKING FACTOR 12, EITHER 800 OR 1600 FPI, ODD PARITY.
C THE FILES ON THE TAPE ARE AS FOLLOWS -
C
C FILE 1 - THESE COMMENTS AND EXAMPLE PROGRAM.
C FILE 2 - MP SUBROUTINES (EXCLUDING EXAMPLE AND TEST PROGRAMS).
C FILE 3 - TEST PROGRAMS (NOT USING AUGMENT INTERFACE).
C FILE 4 - MP USERS GUIDE (DUO-CASE VERSION).
C FILE 5 - AUGMENT DESCRIPTION DECK AND JACOBI PROGRAM USING IT.
C          (MP MAY BE USED WITH THE AUGMENT PREPROCESSOR.  FOR
C           DETAILS SEE SECTION 4 OF THE USERS GUIDE.)
C FILE 6 - MP USERS GUIDE (UPPER-CASE VERSION).
C FILES 7-12 - SAME AS FILES 1-6 EXCEPT 1-6 ARE EBCDIC, 7-12 ASCII.
C
C TO INSTALL MP, READ THESE 6 FILES.  PRINT FILE 4 OR 6 (USERS GUIDE)
C USING THE FIRST CHARACTER (BLANK, +, 0 OR 1) AS STANDARD FORTRAN
C PRINTER CONTROL.  THEN FOLLOW THE INSTRUCTIONS GIVEN IN SECTION
C 9.1 OF THE USERS GUIDE.
C
C CORRESPONDENCE CONCERNING MP SHOULD BE SENT TO -
C
C                PROF. R. P. BRENT,
C                DEPARTMENT OF COMPUTER SCIENCE,
C                AUSTRALIAN NATIONAL UNIVERSITY,
C                BOX 4, CANBERRA, ACT 2600,
C                AUSTRALIA.
C
C $$                   ******  EXAMPLE  ******
C
C THIS PROGRAM COMPUTES PI AND EXP(PI*SQRT(163/9)) TO 100
C DECIMAL PLACES, AND EXP(PI*SQRT(163)) TO 90 DECIMAL PLACES,
C AND WRITES THEM ON LOGICAL UNIT 6.
C
C CORRECT OUTPUT (EXCLUDING HEADINGS) IS AS FOLLOWS
C
C                  3.14159265358979323846264338327950288419716939937510
C                    58209749445923078164062862089986280348253421170680
C             640320.00000000060486373504901603947174181881853947577148
C                    57603665918194652218258286942536340815822646477590
C 262537412640768743.99999999999925007259719818568887935385633733699086
C                    2707537410378210647910118607312951181346
C
C WORKING SPACE IN BLANK COMMON, PARAMETERS IN
C COMMON /MPCOM/ (WHICH HAS LENGTH 23)
      COMMON R
      COMMON /MPCOM/ B, T, M, LUN, MXR, SPTR, MXSPTR, DUMMY
      INTEGER B, T, M, LUN, MXR, SPTR, MXSPTR, DUMMY(16), R(500)
C
C WE HAVE T .LE. 62 IF WORDLENGTH AT LEAST 16 BITS, AND WORKING SPACE
C IS AT MOST 500 WORDS (LESS IF WORDLENGTH IS GREATER THAN 16 BITS).
C
C VARIABLES NEED T+2 .LE. 64 WORDS AND ALLOW 110 CHARACTERS FOR
C DECIMAL OUTPUT
      INTEGER PI(64), X(64), C(110)
C
C CALL MPSET2 TO SET OUTPUT LOGICAL UNIT = 6 AND EQUIVALENT
C NUMBER OF DECIMAL PLACES TO AT LEAST 110.  THE LAST THREE
C PARAMETERS ARE THE DIMENSIONS OF PI (OR X) AND THE LOWER
C AND UPPER INDICES OF BLANK COMMON AVAILABLE TO MP.
      CALL MPSET2 (6, 110, 64, 1, 500)
C
C COMPUTE MULTIPLE-PRECISION PI
      CALL MPPI(PI)
C
C CONVERT TO PRINTABLE FORMAT (F110.100) AND WRITE
      CALL MPOUT (PI, C, 110, 100)
      WRITE (LUN, 10) B, T, C
   10 FORMAT (32H1EXAMPLE OF MP PACKAGE,   BASE =, I9,
     $  12H,   DIGITS =, I4 /// 11H PI TO 100D //
     $  11X, 60A1 / 21X, 50A1)
C
C SET X = SQRT(163/9), THEN MULTIPLY BY PI
      CALL MPQPWR (163, 9, 1, 2, X)
      CALL MPMUL (X, PI, X)
C
C SET X = EXP(X)
      CALL MPEXP (X, X)
C
C CONVERT TO PRINTABLE FORMAT AND WRITE
      CALL MPOUT (X, C, 110, 100)
      WRITE (LUN, 20) C
   20 FORMAT (/ 28H EXP(PI*SQRT(163/9)) TO 100D //
     $        11X, 60A1 / 21X, 50A1)
C
C SET X = X**3 = EXP(PI*SQRT(163))
      CALL MPPWR (X, 3, X)
C
C WRITE IN FORMAT F110.90
      CALL MPOUT (X, C, 110, 90)
      WRITE (LUN, 30) C
   30 FORMAT (/ 25H EXP(PI*SQRT(163)) TO 90D //
     $        1X, 70A1 / 21X, 40A1)
      WRITE (LUN, 40) MXSPTR
   40 FORMAT (/ 21H END OF EXAMPLE, USED, I4,
     $          23H WORDS OF WORKING SPACE //)
      STOP
      END
