C $$                   ******  TEST  ******
C TEST PROGRAM FOR MP PACKAGE
C
C THIS PROGRAM COMPUTES THE CONSTANTS GIVEN IN APPENDIX A
C OF KNUTH, THE ART OF COMPUTER PROGRAMMING, VOL. 3.
C THE CONSTANTS ARE PRINTED IN THE SAME ORDER AS IN KNUTH.
C
C THE CONSTANTS ARE COMPUTED TO 40 DECIMAL PLACES, BUT
C TO INCREASE THE ACCURACY IT IS ONLY NECESSARY TO CHANGE
C THE STATEMENT PLACES = 40, AND POSSIBLY
C THE PARAMETERS OF THE CALL TO MPSET2 AND THE DIMENSIONS
C OF THE ARRAYS.
C
C THE MP ROUTINES NEEDED TO RUN THIS PROGRAM ARE LISTED IN THE MP
C USERS GUIDE.
C
C CORRECT OUTPUT (EXCLUDING HEADINGS) IS AS FOLLOWS
C
C      1.4142135623 7309504880 1688724209 6980785697
C      1.7320508075 6887729352 7446341505 8723669428
C      2.2360679774 9978969640 9173668731 2762354406
C      3.1622776601 6837933199 8893544432 7185337196
C      1.2599210498 9487316476 7210607278 2283505703
C      1.4422495703 0740838232 1638310780 1095883919
C      1.1892071150 0272106671 7499970560 4759152930
C      0.6931471805 5994530941 7232121458 1765680755
C      1.0986122886 6810969139 5245236922 5257046475
C      2.3025850929 9404568401 7991454684 3642076011
C      1.4426950408 8896340735 9924681001 8921374266
C      0.4342944819 0325182765 1128918916 6050822944
C      3.1415926535 8979323846 2643383279 5028841972
C      0.0174532925 1994329576 9236907684 8861271344
C      0.3183098861 8379067153 7767526745 0287240689
C      9.8696044010 8935861883 4490999876 1511353137
C      1.7724538509 0551602729 8167483341 1451827975
C      2.6789385347 0774763365 5692940974 6776441287
C      1.3541179394 2640041694 5288028154 5137855193
C      2.7182818284 5904523536 0287471352 6624977572
C      0.3678794411 7144232159 5523770161 4608674458
C      7.3890560989 3065022723 0427460575 0078131803
C      0.5772156649 0153286060 6512090082 4024310422
C      1.1447298858 4940017414 3427351353 0587116473
C      1.6180339887 4989484820 4586834365 6381177203
C      1.7810724179 9019798523 6504103107 1795491696
C      2.1932800507 3801545655 9769659278 7382234616
C      0.8414709848 0789650665 2502321630 2989996226
C      0.5403023058 6813971740 0936607442 9766037323
C      1.2020569031 5959428539 9738161511 4499907650
C      0.4812118250 5960344749 7758913424 3684231352
C      2.0780869212 3502753760 1322606117 7957677422
C      0.3665129205 8166432701 2439158232 6694694543
C
      COMMON R
      COMMON /MPCOM/ B, T, M, LUN, MXR, SPTR, MXSPTR, DUMMY
      INTEGER B, DUMMY(16), LUN, M, MXR, MXSPTR, SPTR, T
C DIMENSIONS OF R, X, ETC. CAN BE REDUCED IF WORDLENGTH .GT. 16 BITS.
      INTEGER R(500)
C TEMPORARY MP VARIABLES REQUIRE SPACE T+2 AND T .LE. 25.
      INTEGER I, PLACES, X(27), Y(27), PHI(27), PI(27)
C
C SET OUTPUT UNIT = 6 AND WORKING PRECISION TO THE
C EQUIVALENT OF AT LEAST 43 DECIMAL PLACES.  THE OTHER
C PARAMETERS ARE THE DIMENSIONS OF X AND THE INDICES OF THE
C FIRST AND LAST WORDS OF BLANK COMMON AVAILABLE TO MP.
      PLACES = 40
      CALL MPSET2 (6, PLACES+3, 27, 1, 500)
      WRITE (LUN, 5) B, T
    5 FORMAT (29H1TEST OF MP PACKAGE,   BASE =, I9,
     $        11H,  DIGITS =, I3 ///)
C
C COMPUTE SQRT(2), SQRT(3), SQRT(5) AND SQRT(10)
      DO 10 I = 2, 5
      CALL MPQPWR ((5*I)/4 + 4*(I/5), 1, 1, 2, X)
   10 CALL MP40D (PLACES, X)
C COMPUTE 2**(1/3) AND 3**(1/3)
      DO 20 I = 2, 3
      CALL MPQPWR (IABS(I), 1, 1, 3, X)
   20 CALL MP40D (PLACES, X)
C COMPUTE 2**(1/4)
      CALL MPQPWR (2, 1, 1, 4, X)
      CALL MP40D (PLACES, X)
C COMPUTE LN(2), LN(3) AND LN(10)
      DO 30 I = 2, 4
      CALL MPLNI (I + 6*(I/4), X)
   30 CALL MP40D (PLACES, X)
C COMPUTE 1/LN(2) AND 1/LN(10)
C COULD HAVE SAVED ABOVE RESULTS TO SPEED UP HERE
      DO 40 I = 1, 2
      CALL MPLNI (8*I - 6, X)
      CALL MPREC (X, X)
   40 CALL MP40D (PLACES, X)
C COMPUTE PI, PI/180, 1/PI, PI**2, SQRT(PI)
      CALL MPPI (PI)
      CALL MP40D (PLACES, PI)
      CALL MPDIVI (PI, 180, Y)
      CALL MP40D (PLACES, Y)
      CALL MPREC (PI, Y)
      CALL MP40D (PLACES, Y)
      CALL MPPWR (PI, 2, Y)
      CALL MP40D (PLACES, Y)
      CALL MPSQRT (PI, Y)
      CALL MP40D (PLACES, Y)
C COMPUTE GAMMA (1/3)
      CALL MPGAMQ (1, 3, X)
      CALL MP40D (PLACES, X)
C COMPUTE GAMMA (2/3) FROM GAMMA (1/3) (WE COULD
C ALSO CALL MPGAMQ (2, 3, X))
      CALL MPQPWR (3, 4, 1, 2, Y)
      CALL MPMUL (X, Y, X)
      CALL MPDIV (PI, X, X)
      CALL MP40D (PLACES, X)
C COMPUTE E, 1/E, AND E**2
      CALL MPCIM (1, X)
      CALL MPEXP (X, X)
      CALL MP40D (PLACES, X)
      CALL MPREC (X, Y)
      CALL MP40D (PLACES, Y)
      CALL MPMUL (X, X, Y)
      CALL MP40D (PLACES, Y)
C COMPUTE EULERS CONSTANT (GAMMA)
      CALL MPEUL (X)
      CALL MP40D (PLACES, X)
C COMPUTE LN(PI), PHI
      CALL MPLN (PI, Y)
      CALL MP40D (PLACES, Y)
      CALL MPQPWR (5, 4, 1, 2, Y)
      CALL MPADDQ (Y, 1, 2, PHI)
      CALL MP40D (PLACES, PHI)
C COMPUTE EXP(GAMMA)  (GAMMA IS IN X)
      CALL MPEXP (X, X)
      CALL MP40D (PLACES, X)
C COMPUTE EXP(PI/4)
      CALL MPDIVI (PI, 4, X)
      CALL MPEXP (X, X)
      CALL MP40D (PLACES, X)
C COMPUTE SIN(1) AND COS(1)
      CALL MPCIM (1, X)
      CALL MPCIS (X, X, Y, .TRUE.)
      CALL MP40D (PLACES, Y)
      CALL MP40D (PLACES, X)
C COMPUTE ZETA(3)
      CALL MPZETA (3, X)
      CALL MP40D (PLACES, X)
C COMPUTE LN(PHI), 1/LN(PHI), AND -LN(LN(2))
      CALL MPLN(PHI, X)
      CALL MP40D (PLACES, X)
      CALL MPREC (X, X)
      CALL MP40D (PLACES, X)
      CALL MPLNI (2, X)
      CALL MPLN (X, X)
      X(1) = -X(1)
      CALL MP40D (PLACES, X)
      WRITE (LUN, 80) MXSPTR
   80 FORMAT (/ 18H END OF TEST, USED, I4,
     $          23H WORDS OF WORKING SPACE //)
      STOP
      END
