C $$                   ******  TEST2  ******
C TEST2 PROGRAM FOR MP PACKAGE
C
C THIS PROGRAM TESTS VARIOUS MP ROUTINES, ESPECIALLY THOSE NOT
C CALLED BY PROGRAM TEST.  IT COMPUTES THE CONSTANTS GIVEN IN
C COMPUTER APPROXIMATIONS (BY HART, CHENEY, LAWSON, MAEHLY,
C MESZTENYI, RICE, THACHER AND WITZGALL, JOHN WILEY, 1968),
C APPENDIX C, PP. 182-183, AND VARIOUS OTHER CONSTANTS
C WHICH ARE DESCRIBED IN THE COMMENTS BELOW.  THE CONSTANTS
C ARE COMPUTED TO 40 SIGNIFICANT FIGURES, WITH WORKING PRECISION
C EQUIVALENT TO AT LEAST 43 SIGNIFICANT FIGURES.
C
C CORRECT OUTPUT ON A UNIVAC 1100/42 (36-BIT WORD) IS
C AS FOLLOWS.  ON MACHINES WITH WORDLENGTH OTHER THAN 36 BITS
C THERE WILL BE SOME MINOR DIFFERENCES.  THE RESULTS GIVEN
C BELOW ARE CORRECTLY ROUNDED TO 40 SIGNIFICANT FIGURES.
C
C TEST2 OF MP PACKAGE,   BASE =    65536,  DIGITS = 10
C
C CONSTANTS IN HART ET AL (ORDER DIFFERENT)
C
C  4.848136811095359935899141023579479759564E-0005
C  1.745329251994329576923690768488612713443E-0002
C  3.926990816987241548078304229099378605246E-0001
C  5.641895835477562869480794515607725858441E-0001
C  6.366197723675813430755350534900574481378E-0001
C  7.853981633974483096156608458198757210493E-0001
C  7.978845608028653558798921198687637369517E-0001
C  9.189385332046727417803297364056176398614E-0001
C  1.570796326794896619231321691639751442099E+0000
C  1.772453850905516027298167483341145182798E+0000
C  2.356194490192344928846982537459627163148E+0000
C  3.141592653589793238462643383279502884197E+0000
C  6.283185307179586476925286766559005768394E+0000
C  3.678794411714423215955237701614608674458E-0001
C  7.788007830714048682451702669783206472968E-0001
C  1.284025416687741484073420568062436458336E+0000
C  2.718281828459045235360287471352662497757E+0000
C  5.772156649015328606065120900824024310422E-0001
C  1.090507732665257659207010655760707978993E+0000
C  1.189207115002721066717499970560475915293E+0000
C  1.414213562373095048801688724209698078570E+0000
C  3.162277660168379331998893544432718533720E+0000
C  1.259921049894873164767210607278228350570E+0000
C  1.587401051968199474751705639272308260391E+0000
C  2.154434690031883721759293566519350495259E+0000
C  4.641588833612778892410076350919446576551E+0000
C  1.442695040888963407359924681001892137427E+0000
C  3.321928094887362347870319429489390175865E+0000
C  3.465735902799726547086160607290882840378E-0001
C  6.931471805599453094172321214581765680755E-0001
C  1.386294361119890618834464242916353136151E+0000
C  2.302585092994045684017991454684364207601E+0000
C  3.010299956639811952137388947244930267682E-0001
C  4.342944819032518276511289189166050822944E-0001
C  1.305261922200515915484062278954890101937E-0001
C  1.950903220161282678482848684770222409277E-0001
C  2.588190451025207623488988376240483283491E-0001
C  5.000000000000000000000000000000000000000E-0001
C  7.071067811865475244008443621048490392848E-0001
C  8.660254037844386467637231707529361834714E-0001
C  2.474039592545229295968487048493891958934E-0001
C  4.794255386042030002732879352155713880818E-0001
C  8.414709848078965066525023216302989996226E-0001
C  9.238795325112867561281831893967882868224E-0001
C  9.659258262890682867497431997288973676339E-0001
C  9.849140335716425307719752129132743229305E-0002
C  1.989123673796580069115976226446762285979E-0001
C  2.679491924311227064725536584941276330572E-0001
C  4.142135623730950488016887242096980785697E-0001
C  5.773502691896257645091487805019574556476E-0001
C  1.000000000000000000000000000000000000000E+0000
C  1.732050807568877293527446341505872366943E+0000
C  2.553419212210362665044822364904736782042E-0001
C  5.463024898437905132551794657802853832976E-0001
C  1.557407724654902230506974807458360173087E+0000
C  2.864256869924070484773772302378002636590E-0001
C  4.563200724962071954298288879197037326544E-0001
C  5.323280990604765985693418601514840681969E-0001
C  6.020994932348296742913495709025331582540E-0001
C  7.236648875473587964064629355277428962481E-0001
C  7.761882222734748449391348929091469265099E-0001
C  8.238049667103636277653479963181034453800E-0001
C  8.669840139434846676407863266118724492986E-0001
C  9.061778032186181584326793796610085912753E-0001
C  9.184307960450497544469833659648160928434E-0001
C  9.418086078468580771196106632361044035158E-0001
C  9.742619823209360312818256760119330624856E-0001
C  8.516319137048080127004060150609260682003E-0001
C  4.720012157682347674476683878725009623642E-0001
C  3.631878383468673317955937477889247216476E-0001
C  5.668240889058739377112449634671602835403E-0001
C  2.369974904082422018721147551606796861398E-0011
C  2.326614794865976450546482207237974647586E-0008
C  4.769362762044698733814183536431305598090E-0001
C
C TEST OF MPASIN AND MPATAN
C
C  1.000016667416711312562227707199038367857E-0002
C -5.235987755982988730771072305465838140329E-0001
C  1.429256853470469400485532334664724427105E+0000
C  9.999666686665238206340116209279548561369E-0003
C -6.435011087932843868028092287173226380415E-0001
C  1.471127674303734591852875571761730851855E+0000
C
C TEST OF MPBESJ
C
C  9.999750001562495659729003899468320681723E-0001
C  9.975015620660400322812868984747920848320E-0001
C  7.651976865579665514497175261026632209093E-0001
C -2.459357644513483351977608624853287538296E-0001
C  1.998585030422312242422839095084899068063E-0002
C  2.478668615242017456133073111569370878617E-0002
C  4.999937500260416124132622612282082222967E-0003
C  4.993752603624199755633655243780648405856E-0002
C  4.400505857449335159596822037189149131274E-0001
C  4.347274616886143666974876802585928830627E-0002
C -7.714535201411215803268549492723447021161E-0002
C  4.728311907089523917576071901216916285418E-0003
C  2.170131138404967281693651142150815094613E-0017
C  2.169363960376002380635265343042715360913E-0011
C  2.093833800238926996560701453800780000026E-0005
C -1.445884208478510531774561260148174874671E-0002
C -3.352538314417667427285301848429116213846E-0002
C -2.469801093420243996535541028052587615959E-0002
C  2.368598385174410068779331157930426751244E-0274
C  2.368519166467611069896185607645793014427E-0201
C  2.360610483197187577029325106563488361132E-0128
C  1.688254978074890509296827170625271452023E-0055
C  9.633817342050361437615884024435958149431E-0002
C  7.173642352660120247867318411619579007593E-0003
C  1.300924406738082128445548553616298220657E-0671
C  1.300904893017434872887808473358528762111E-0507
C  1.298954989483319596748137632393071785666E-0343
C  1.117943529279165433085063648308631625217E-0179
C  1.547555253553207391363466511764830851880E-0022
C  1.152259751253901478112859948236454927804E-0002
C  1.944998262170446054748125826967690995132E-3818
C  1.944992252353628101811176793079875375991E-3018
C  1.944391364322010861731787302600779281025E-2218
C  1.885229418999920133044032342021032255068E-1418
C  8.526917009536047015776970746427276966500E-0620
C -2.987223375566258955506328177917819328443E-0002
C
C TEST OF MPERF, MPERFC AND MPDAW
C
C -1.000000000000000000000000000000000000000E+0000
C  2.000000000000000000000000000000000000000E+0000
C -5.000250037509378282727375137642333908163E-0003
C -1.000000000000000000000000000000000000000E+0000
C  2.000000000000000000000000000000000000000E+0000
C -5.025384718759852803274841986071548588791E-0002
C -8.427007929497148693412206350826092592961E-0001
C  1.842700792949714869341220635082609259296E+0000
C -5.380795069127684191363874204075567547920E-0001
C -1.124629160182848922032750717439683832217E-0001
C  1.112462916018284892203275071743968383222E+0000
C -9.933599239785286114978869519231223541097E-0002
C  1.124629160182848922032750717439683832217E-0001
C  8.875370839817151077967249282560316167783E-0001
C  9.933599239785286114978869519231223541097E-0002
C  8.427007929497148693412206350826092592961E-0001
C  1.572992070502851306587793649173907407039E-0001
C  5.380795069127684191363874204075567547920E-0001
C  1.000000000000000000000000000000000000000E+0000
C  2.088487583762544757000786294957788611561E-0045
C  5.025384718759852803274841986071548588791E-0002
C  1.000000000000000000000000000000000000000E+0000
C  6.405961424921732039021339148586394148214E-4346
C  5.000250037509378282727375137642333908163E-0003
C
C TEST OF MPGAM
C
C  3.993599489724414140919056205879117156950E-0038
C  4.113526718873633300615263770795138677800E+0000
C  9.999422883231624190805737422564434215028E+0003
C  3.447019240352198953918716891440225225102E+0002
C  1.216451004088320000000000000000000000000E+0017
C  4.023872600770937735437024339230039857194E+2564
C  1.272301195695055464182244180377444569507E+2566
C
C TEST OF MPSIN, COS, TAN, SINH, COSH, TANH
C
C  5.063656411097587936565576104597854320650E-0001
C  8.623188722876839341019385139508425355101E-0001
C  5.872139151569290766778096356445878942588E-0001
C -1.344058570908067724206312775790006793681E+0043
C  1.344058570908067724206312775790006793681E+0043
C -1.000000000000000000000000000000000000000E+0000
C  5.440211108893698134047476618513772816836E-0001
C -8.390715290764524522588639478240648345199E-0001
C -6.483608274590866712591249330098086768169E-0001
C -1.101323287470339337723652455484636440290E+0004
C  1.101323292010332313972137609043787996345E+0004
C -9.999999958776927636195928371382757410508E-0001
C -8.414709848078965066525023216302989996226E-0001
C  5.403023058681397174009366074429766037323E-0001
C -1.557407724654902230506974807458360173087E+0000
C -1.175201193643801456882381850595600815156E+0000
C  1.543080634815243778477905620757061682602E+0000
C -7.615941559557648881194582826047935904128E-0001
C -9.983341664682815230681419841062202698992E-0002
C  9.950041652780257660955619878038702948386E-0001
C -1.003346720854505450580800457811115368190E-0001
C -1.001667500198440258237293835219050235149E-0001
C  1.005004168055803598987978442968341644710E+0000
C -9.966799462495581711830508367835218353896E-0002
C  9.983341664682815230681419841062202698992E-0002
C  9.950041652780257660955619878038702948386E-0001
C  1.003346720854505450580800457811115368190E-0001
C  1.001667500198440258237293835219050235149E-0001
C  1.005004168055803598987978442968341644710E+0000
C  9.966799462495581711830508367835218353896E-0002
C  8.414709848078965066525023216302989996226E-0001
C  5.403023058681397174009366074429766037323E-0001
C  1.557407724654902230506974807458360173087E+0000
C  1.175201193643801456882381850595600815156E+0000
C  1.543080634815243778477905620757061682602E+0000
C  7.615941559557648881194582826047935904128E-0001
C -5.440211108893698134047476618513772816836E-0001
C -8.390715290764524522588639478240648345199E-0001
C  6.483608274590866712591249330098086768169E-0001
C  1.101323287470339337723652455484636440290E+0004
C  1.101323292010332313972137609043787996345E+0004
C  9.999999958776927636195928371382757410508E-0001
C -5.063656411097587936565576104597854320650E-0001
C  8.623188722876839341019385139508425355101E-0001
C -5.872139151569290766778096356445878942588E-0001
C  1.344058570908067724206312775790006793681E+0043
C  1.344058570908067724206312775790006793681E+0043
C  1.000000000000000000000000000000000000000E+0000
C
C TEST OF MPLI AND MPEI
C
C -1.247678559626375088840194710872203816285E-0004
C -6.353279339727591513585474237270429058630E+0000
C -6.355232464831071802614455519358032212938E+0000
C -6.354744461697291123056164840748548577634E+0000
C  1.892463243835693144140481263216406702938E+0000
C -2.197435427851990963896917162334182400288E-0001
C -6.353767899171421044877727316545766253157E+0000
C  1.897772388875768322684241430851491375948E+0000
C -2.190250276806367219674691602503337494018E-0001
C -5.299113807150346461381605153457779262963E-0004
C  3.156552081410363613766570878788022081110E+0000
C -1.075880501319490268122213298905290428959E-0001
C  6.165599504787297937522981752669522749131E+0000
C  2.492228976241877759138440143998524848990E+0003
C -4.156968929685324277402859810278180384346E-0006
C  3.012614158407962992590174133903218497960E+0001
C  2.715552744853879821914014642310825410296E+0041
C -3.683597761682032180235192620508118987655E-0046
C  1.776096579901522266876406239486993179786E+0002
C  1.972045137141238302809645048412023552690E+0431
C -5.070893060235166549927200999685925144667E-0438
C  1.246137215899388459692771107529059792487E+0003
C  8.807699083674714448970900245119101084640E+4338
C -1.135370339631071751833431428951800778261E-4347
C
C TEST OF MPZETA
C
C  1.202056903159594285399738161511449990765E+0000
C  1.082323233711138191516003696541167902775E+0000
C  1.036927755143369926331365486457034168057E+0000
C  1.000994575127818085337145958900319017006E+0000
C  1.000000953962033872796113152038683449346E+0000
C  1.000000000000909494784026388928253311839E+0000
C
C TEST OF MPCAM, MPGCDA AND MPGCDB
C
C  1.230000000000000000000000000000000000000E-0004
C -5.000000000000000000000000000000000000000E+1232
C  2.345600000000000000000000000000000000000E+0790
C  2.EF405BEFC1CE7A4CD25B45DC41336$+00000290
C  1.524157875319616034331961603431672002468E+39
C -2.895899851996160343319616034316720024680E+39
C  1.234567890120000000000000000000000000000E+11
C  1.234567890123456789012345678900000000000E+28
C -2.345678901234567890123456789000000000000E+28
C
C TEST VARYING DIGITS, BASE AND ROUNDING RULE
C
C  2.625374123E+17
C  2.625374124E+17
C  2.625374121E+17
C  2.625374132E+17
C  2.625374128E+17
C  2.625374128E+17
C  2.625374117E+17
C  2.625374129E+17
C  2.625374129E+17
C  2.625374130E+17
C  2.625374121E+17
C  2.625374133E+17
C  2.6253741264076874396E+17
C  2.6253741264076874396E+17
C  2.6253741264076874390E+17
C  2.6253741264076874416E+17
C  2.6253741264076874407E+17
C  2.6253741264076874409E+17
C  2.6253741264076874384E+17
C  2.6253741264076874410E+17
C  2.6253741264076874398E+17
C  2.6253741264076874400E+17
C  2.6253741264076874393E+17
C  2.6253741264076874419E+17
C  2.62537412640768743999999999999E+17
C  2.62537412640768743999999999999E+17
C  2.62537412640768743999999999999E+17
C  2.62537412640768744000000000000E+17
C  2.62537412640768743999999999999E+17
C  2.62537412640768743999999999999E+17
C  2.62537412640768743999999999999E+17
C  2.62537412640768744000000000000E+17
C  2.62537412640768743999999999999E+17
C  2.62537412640768743999999999999E+17
C  2.62537412640768743999999999999E+17
C  2.62537412640768744000000000000E+17
C  2.625374126407687439999999999992500725972E+17
C  2.625374126407687439999999999992500725972E+17
C  2.625374126407687439999999999992500725971E+17
C  2.625374126407687439999999999992500725972E+17
C  2.625374126407687439999999999992500725972E+17
C  2.625374126407687439999999999992500725972E+17
C  2.625374126407687439999999999992500725971E+17
C  2.625374126407687439999999999992500725972E+17
C  2.625374126407687439999999999992500725972E+17
C  2.625374126407687439999999999992500725972E+17
C  2.625374126407687439999999999992500725971E+17
C  2.625374126407687439999999999992500725972E+17
C
C TEST OF VARIOUS MP ROUTINES
C
C  1.144729885849400174143427351353058711647E+00
C  2.245915771836104547342715220454373502759E+01
C  3.095891371701158559100259628453669451579E+01
C -3.141592653589793238462643383279502884197E+00
C -3.141592653589793238462643383279502884197E+**
C -3.141592653589793238462643383279502884197E+1234
C  3.100627660751343     1
C  3.100627668029982014200000000000     1
C  3.1006276680299820148E+0001
C  5.915477618586312249935148194956040327282E+0039
C  1                     -8             1       655     23592     62914
C                                   36700     10485     49807     23592
C                                   62914     36701
C  1            -8589934590             1         0         0         0
C                                       0         0         0         0
C                                       0         0
C  1             8589934591         65535     65535     65535     65535
C                                   65535     65535     65535     65535
C                                   65535     65535
C        ************* ********** ********** **********
C  0.000000000000000000000000000000000000000E+0000
C
C FINAL CONTENTS OF COMMON /MPCOM/
C            65536              10      8589934591               6
C              500               1             266               1
C       8589934591     -8589934591               0               1
C                0              43              27     34359738367
C                6              80              10              10
C                E               6               1
C
C END OF TEST2, USED  266 WORDS OF WORKING SPACE
C
C TO CONFORM TO THE FORTRAN STANDARD WE SHOULD DECLARE BLANK AND
C LABELLED COMMON HERE, FOR EXAMPLE -
C
      COMMON MPWORK
      COMMON /MPCOM/ MPPAR
      INTEGER MPPAR(23), MPWORK(500)
C
C THIS IS NECESSARY ON SOME SYSTEMS (E.G. BURROUGHS B6700),
C BUT NOT ON MOST.  SEE COMMENTS IN MPINIT FOR MORE DETAILS.
C
C T .LE. 25 FOR WORDLENGTH AT LEAST 16 BITS.  DIMENSIONS OF
C W, X ETC. CAN BE REDUCED IF WORDLENGTH EXCEEDS 16 BITS.
C DIMENSION OF W, X ETC. MUST AGREE WITH MT2 - SEE BELOW.
C DIMENSION OF A MUST AGREE WITH IDIMA - SEE BELOW.
C
      INTEGER A(43), BASE, DECPL, I, ID, IDIMA, IDUMMY(1), ILIM,
     $  J, JL, J1(3), J10(3), J11(7), J12(7), J13(8), J14(4),
     $  J15(6), J16(6), J2(4), J3(3), J4(4), J5(6), J6(7), J7(12),
     $  J8(3), J9(3), K, KTU, KTV, LUN, MPC(23), MT2, MXSPTR, N,
     $  NUMDIG, N2, PI(27), SV, W(27), X(27), Y(27), Z(27),
     $  MPCHGB, MPDIGS, MPPARN, MPSIGA
      LOGICAL ERROR
      REAL RX
      DOUBLE PRECISION DX
C
C MT2 MUST EQUAL DIMENSION OF ARRAYS W, X ETC. ABOVE (AT LEAST
C T+2 FOR T-DIGIT MP NUMBERS).
C
C IDIMA MUST EQUAL DIMENSION OF ARRAY A ABOVE (AT LEAST DECPL+3
C FOR DECPL SIGNIFICANT DECIMAL PLACES IN OUTPUT).
C
      DATA MT2 /27/,  IDIMA /43/
C
C DATA FOR TEST ARGUMENTS
C
      DATA J1(1), J1(2), J1(3) /16200, 45, 2/
      DATA J2(1), J2(2), J2(3), J2(4) /-1, -4, 4, 1/
      DATA J3(1), J3(2), J3(3) /8, 4, 2/
      DATA J4(1), J4(2), J4(3), J4(4) /2, 4, 10, 100/
      DATA J5(1), J5(2), J5(3) /24, 16, 12/
      DATA J5(4), J5(5), J5(6) /6, 4, 3/
      DATA J6(1), J6(2), J6(3) /32, 16, 12/
      DATA J6(4), J6(5), J6(6), J6(7) /8, 6, 4, 3/
      DATA J7(1), J7(2), J7(3), J7(4) /9, 15, 18, 21/
      DATA J7(5), J7(6), J7(7), J7(8) /27, 30, 33, 36/
      DATA J7(9), J7(10), J7(11), J7(12) /39, 40, 42, 45/
      DATA J8(1), J8(2), J8(3) /0, 1, 10/
      DATA J9(1), J9(2), J9(3) /1, -50, 99/
      DATA J10(1), J10(2), J10(3) /4, -300, 4000/
      DATA J11(1), J11(2), J11(3), J11(4) /-101, -13, 1, 33/
      DATA J11(5), J11(6), J11(7) /20, 1000, 2001/
      DATA J12(1), J12(2), J12(3) /3, 7, 10000/
      DATA J12(4), J12(5), J12(6), J12(7) /5, 1, 1, 2/
      DATA J13(1), J13(2), J13(3) /1, 1023, 1025/
      DATA J13(4), J13(5), J13(6) /1486, 10, 100/
      DATA J13(7), J13(8) /1000, 10000/
      DATA J14(1), J14(2), J14(3), J14(4) /-1, 3, -4, 2/
      DATA J15(1), J15(2), J15(3) /0, 1, 6/
      DATA J15(4), J15(5), J15(6) /73, 164, 800/
      DATA J16(1), J16(2), J16(3) /3, 4, 5/
      DATA J16(4), J16(5), J16(6) /10, 20, 40/
C
C INITIALIZE USING MPINIT.  THE STANDARD VERSION OF MPINIT SETS
C THE PRECISION TO THE EQUIVALENT OF AT LEAST 43 DECIMAL PLACES.
C IF NONSTANDARD VERSIONS OF MPINIT ARE USED, THE DIMENSION AND
C DATA STATEMENTS ABOVE MAY HAVE TO BE CHANGED.
C
      CALL MPINIT (IDUMMY)
C
C USE MPPARM TO GET THE BASE, NUMBER OF DIGITS ETC.
C IT IS EASIER TO USE THE FUNCTION MPPARA, BUT THE PFORT
C VERIFIER OBJECTS TO FUNCTIONS WITH HOLLERITH ARGUMENTS.
C
      CALL MPPARM (4HBASE, .FALSE., BASE)
      CALL MPPARM (6HNUMDIG, .FALSE., NUMDIG)
      CALL MPPARM (3HLUN, .FALSE., LUN)
C
C SEE ABOVE REGARDING IDIMA.
      CALL MPPARM (5HDECPL, .FALSE., DECPL)
      DECPL = MIN0 (IDIMA - 3, DECPL)
C
      WRITE (LUN, 10) BASE, NUMDIG
   10 FORMAT (30H1TEST2 OF MP PACKAGE,   BASE =, I9,
     $  11H,  DIGITS =, I3)
C
C CHECK THAT VERSION OF MPINIT USED IS COMPATIBLE WITH TEST2.
C
      N2 = NUMDIG + 2
      IF (MT2 .GE. N2) GO TO 20
      WRITE (LUN, 15) N2
   15 FORMAT (48H *** INCREASE MT2 AND DIMENSIONS OF W, X ETC. TO /
     $  9H AT LEAST, I6, 13H IN TEST2 ***)
      CALL MPERR
      STOP
C
C COMPUTE PI USING GAUSS-LAGRANGE METHOD
   20 CALL MPPIGL (PI)
C
C COMPUTE CONSTANTS GIVEN IN HART ET AL, IN APPROXIMATELY THE
C SAME ORDER AS GIVEN THERE.
      WRITE (LUN, 25)
   25 FORMAT (/ 42H CONSTANTS IN HART ET AL (ORDER DIFFERENT) /)
C
C COMPUTE PI/64800, PI/180, PI/8
      CALL MPDIVI (PI, 4, Y)
      DO 30 I = 1, 3
      CALL MPDIVI (Y, J1(I), X)
C WRITE ON UNIT LUN (SEE CALL TO MPSET ABOVE).
   30 CALL MPFOUT (X, DECPL)
C COMPUTE SQRT(1/PI)
      CALL MPROOT (PI, -2, X)
      CALL MPFOUT (X, DECPL)
C COMPUTE 2/PI
      CALL MPDIVI (PI, 2, Z)
      CALL MPREC (Z, Z)
      CALL MPFOUT (Z, DECPL)
C PRINT PI/4 (ALREADY IN Y)
      CALL MPFOUT (Y, DECPL)
C COMPUTE SQRT (2/PI)
      CALL MPSQRT (Z, X)
      CALL MPFOUT (X, DECPL)
C COMPUTE LN(SQRT(2*PI))
      CALL MPMULI (PI, 2, Z)
      CALL MPLN (Z, X)
      CALL MPDIVI (X, 2, X)
      CALL MPFOUT (X, DECPL)
C COMPUTE PI/2
      CALL MPDIVI (PI, 2, X)
      CALL MPFOUT (X, DECPL)
C COMPUTE SQRT (PI)
      CALL MPSQRT (PI, X)
      CALL MPFOUT (X, DECPL)
C COMPUTE 3PI/4, PI, 2PI
      CALL MPMULQ (PI, 3, 4, X)
      CALL MPFOUT (X, DECPL)
      CALL MPFOUT (PI, DECPL)
      CALL MPFOUT (Z, DECPL)
C COMPUTE EXP(-1), EXP(-1/4), EXP(1/4), EXP(1)
      DO 35 I = 1, 4
      CALL MPCQM (1, J2(I), X)
      CALL MPEXP (X, X)
   35 CALL MPFOUT (X, DECPL)
C COMPUTE EULERS CONSTANT
      CALL MPEUL (X)
      CALL MPFOUT (X, DECPL)
C COMPUTE SQRT(SQRT(SQRT(2))), SQRT(SQRT(2)), SQRT(2)
      DO 40 I = 1, 3
      CALL MPQPWR (2, 1, 1, J3(I), X)
   40 CALL MPFOUT (X, DECPL)
C COMPUTE SQRT(10)
      CALL MPQPWR (10, 1, 1, 2, X)
      CALL MPFOUT (X, DECPL)
C COMPUTE CUBE ROOT OF 2, 4, 10, 100
      DO 45 I = 1, 4
      CALL MPQPWR (J4(I), 1, 1, 3, X)
   45 CALL MPFOUT (X, DECPL)
C COMPUTE LOG2(E), LOG2(10)
      CALL MPLNI (2, W)
      CALL MPREC (W, Y)
      CALL MPFOUT (Y, DECPL)
      CALL MPLNI (10, Z)
      CALL MPMUL (Z, Y, X)
      CALL MPFOUT (X, DECPL)
C COMPUTE LN(SQRT(2)), LN(2), LN(4), LN(10)
      CALL MPDIVI (W, 2, X)
      CALL MPFOUT (X, DECPL)
      CALL MPFOUT (W, DECPL)
      CALL MPMULI (W, 2, X)
      CALL MPFOUT (X, DECPL)
      CALL MPFOUT (Z, DECPL)
C COMPUTE LOG10(2), LOG10(E)
      CALL MPCIM (2, X)
      CALL MPLG10 (X, X)
      CALL MPFOUT (X, DECPL)
      CALL MPREC (Z, X)
      CALL MPFOUT (X, DECPL)
C COMPUTE SIN(PI/J) FOR J = 24, 16, 12, 6, 4, 3
C NOTE - ORDER IS SLIGHTLY DIFFERENT FROM HART ET AL HERE
      DO 50 I = 1, 6
      CALL MPDIVI (PI, J5(I), X)
      CALL MPSIN (X, X)
   50 CALL MPFOUT (X, DECPL)
C COMPUTE SIN(1/4), SIN(1/2), SIN(1)
      DO 60 I = 1, 3
      CALL MPCQM (1, 2**(3-I), X)
      CALL MPSIN (X, X)
   60 CALL MPFOUT (X, DECPL)
C COMPUTE SIN(3PI/8), SIN(5PI/12)
      CALL MPMULQ (PI, 3, 8, X)
      CALL MPSIN (X, X)
      CALL MPFOUT (X, DECPL)
      CALL MPMULQ (PI, 5, 12, X)
      CALL MPSIN (X, X)
      CALL MPFOUT (X, DECPL)
C COMPUTE TAN (PI/J) FOR J = 32, 16, 12, 8, 6, 4, 3
C NOTE - ORDER IS SLIGHTLY DIFFERENT FROM HART ET AL
      DO 70 I = 1, 7
      CALL MPDIVI (PI, J6(I), X)
      CALL MPTAN (X, X)
   70 CALL MPFOUT (X, DECPL)
C COMPUTE TAN (1/4), TAN (1/2), TAN(1)
      DO 80 I = 1, 3
      CALL MPCQM (1, 2**(3-I), X)
      CALL MPTAN (X, X)
   80 CALL MPFOUT (X, DECPL)
C COMPUTE TAN(J*PI/96) FOR J = 9, 15, 18, 21, 27, 30,
C                              33, 36, 39, 40, 42, 45
      CALL MPCIM (96, Y)
      DO 90 I = 1, 12
      CALL MPMULI (PI, J7(I), X)
      CALL MPATN2 (X, Y, X)
   90 CALL MPFOUT (X, DECPL)
C COMPUTE J(NU, PI/4) AND J(NU, PI/2) FOR NU = 0, 1, 10
      DO 100 I = 1, 3
      CALL MPDIVI (PI, 4, X)
      CALL MPBESJ (X, J8(I), X)
      CALL MPFOUT (X, DECPL)
      CALL MPDIVI (PI, 2, X)
      CALL MPBESJ (X, J8(I), X)
  100 CALL MPFOUT (X, DECPL)
C COMPUTE ARCERF(1/2) USING NEWTONS METHOD WITH FIRST
C APPROXIMATION 0.477
      CALL MPSQRT (PI, Y)
      CALL MPDIVI (Y, 2, Y)
C COMPUTE NUMBER OF ITERATIONS NECESSARY
      ILIM = MPCHGB (2, (DECPL+1)/2, 1)
      CALL MPCQM (477, 1000, X)
C COULD SAVE TIME BY REDUCING T AT FIRST (SEE EG MPREC)
      DO 110 I = 1, ILIM
      CALL MPERF (X, Z)
      CALL MPADDQ (Z, -1, 2, Z)
      CALL MPMUL (X, X, W)
      CALL MPEXP (W, W)
      CALL MPMUL (W, Y, W)
      CALL MPMUL (W, Z, Z)
  110 CALL MPSUB (X, Z, X)
      CALL MPFOUT (X, DECPL)
C
C FINISHED WITH CONSTANTS IN HART ET AL, NOW COMPUTE SOME MORE
C TO TEST OTHER MP ROUTINES
C
      WRITE (LUN, 115)
  115 FORMAT (/ 26H TEST OF MPASIN AND MPATAN /)
C COMPUTE ASIN(1/100), ASIN(-1/2), ASIN(99/100)
      DO 120 I = 1, 3
      CALL MPCQM (J9(I), 100, X)
      CALL MPASIN (X, X)
  120 CALL MPFOUT (X, DECPL)
C COMPUTE ATAN(1/100), ATAN(-3/4), ATAN(10)
      DO 130 I = 1, 3
      CALL MPCQM (J10(I), 400, X)
      CALL MPATAN (X, X)
  130 CALL MPFOUT (X, DECPL)
      WRITE (LUN, 135)
  135 FORMAT (/ 15H TEST OF MPBESJ /)
C COMPUTE J(NU, X) FOR X = 0.01, 0.1, 1, 10, 100, 1000
C                  AND NU = 0, 1, 6, 73, 164, 800
      DO 150 I = 1, 6
      DO 140 J = 1, 6
      IF (J.LT.3) CALL MPCQM (1, 10**(3-J), X)
      IF (J.GE.3) CALL MPCQM (10**(J-3), 1, X)
      CALL MPBESJ (X, J15(I), X)
  140 CALL MPFOUT (X, DECPL)
  150 CONTINUE
      WRITE (LUN, 155)
  155 FORMAT (/ 32H TEST OF MPERF, MPERFC AND MPDAW /)
C COMPUTE ERF(X), ERFC(X), AND DAW(X) (DAWSONS INTEGRAL) FOR
C X = -100, -10, -1, -0.1, 0.1, 1, 10, 100
      DO 160 I = 1, 8
      IF (I.LE.4) CALL MPCQM (10**(4-I), -10, X)
      IF (I.GT.4) CALL MPCQM (10**(I-5), 10, X)
      CALL MPERF (X, Y)
      CALL MPFOUT (Y, DECPL)
      CALL MPERFC (X, Y)
      CALL MPFOUT (Y, DECPL)
      CALL MPDAW (X, Y)
  160 CALL MPFOUT (Y, DECPL)
      WRITE (LUN, 165)
  165 FORMAT (/ 14H TEST OF MPGAM /)
C COMPUTE GAMMA(X) FOR X = -101/3, -13/7, 1/10000, 33/5, 20,
C                          1000, 2001/2
      DO 170 I = 1, 7
      CALL MPCQM (J11(I), J12(I), X)
      CALL MPGAM (X, X)
  170 CALL MPFOUT (X, DECPL)
      WRITE (LUN, 175)
  175 FORMAT (/ 42H TEST OF MPSIN, COS, TAN, SINH, COSH, TANH /)
C COMPUTE SIN(X), COS(X), TAN(X), SINH(X), COSH(X) AND TANH(X)
C FOR X = -100, -10, -1, -0.1, 0.1, 1, 10, 100
      DO 180 I = 1, 8
      IF (I.LE.4) CALL MPCQM (10**(4-I), -10, X)
      IF (I.GT.4) CALL MPCQM (10**(I-5), 10, X)
      CALL MPSIN (X, Y)
      CALL MPFOUT (Y, DECPL)
      CALL MPCOS (X, Y)
      CALL MPFOUT (Y, DECPL)
      CALL MPTAN (X, Y)
      CALL MPFOUT (Y, DECPL)
      CALL MPSINH (X, Y)
      CALL MPFOUT (Y, DECPL)
      CALL MPCOSH (X, Y)
      CALL MPFOUT (Y, DECPL)
      CALL MPTANH (X, Y)
  180 CALL MPFOUT (Y, DECPL)
      WRITE (LUN, 185)
  185 FORMAT (/ 22H TEST OF MPLI AND MPEI /)
C COMPUTE LI(X), EI(X), EI(-X) FOR X = 1/1024, 1023/1024,
C 1025/1024, 1486/1024, 10, 100, 1000, 10000
      DO 190 I = 1, 8
      ID = 1024
      IF (I.GT.4) ID = 1
      CALL MPCQM (J13(I), ID, X)
      CALL MPLI (X, Y)
      CALL MPFOUT (Y, DECPL)
      CALL MPEI (X, Y)
      CALL MPFOUT (Y, DECPL)
      CALL MPNEG (X, X)
      CALL MPEI (X, Y)
  190 CALL MPFOUT (Y, DECPL)
      WRITE (LUN, 195)
  195 FORMAT (/ 15H TEST OF MPZETA /)
C COMPUTE ZETA(I) FOR I = 3, 4, 5, 10, 20, 40
      DO 200 I = 1, 6
      CALL MPZETA (J16(I), X)
  200 CALL MPFOUT (X, DECPL)
      WRITE (LUN, 210)
  210 FORMAT (/ 33H TEST OF MPCAM, MPGCDA AND MPGCDB /)
C TEST MPCAM.
      CALL MPCAM (7H123E-6$, Y)
      CALL MPFOUT (Y, DECPL)
      CALL MPCAM (10H-.05D1234$, Y)
      CALL MPFOUT (Y, DECPL)
      CALL MPCAM (12H+23.456+789$, Y)
      CALL MPFOUT (Y, DECPL)
C CHANGE OUTPUT BASE TO 16, EXPONENT FIELD WIDTH TO 10
      CALL MPPARB (16, 7HOUTBASE)
      CALL MPPARB (10, 7HEXWIDTH)
C WRITE Y AGAIN, THIS TIME WITH BASE 16 AND 30 DIGITS
      CALL MPFOUT (Y, 30)
C RESTORE OUTPUT BASE TO 10, SET EXPONENT WIDTH TO 4
      CALL MPPARB (10, 3HOUT)
      CALL MPPARB (4, 3HEXW)
      CALL MPCAM (43H1524157875319616034331961603431672002468.0$, X)
      CALL MPFOUT (X, DECPL)
      CALL MPCAM (42H-2895899851996160343319616034316720024680$, Y)
      CALL MPFOUT (Y, DECPL)
C TEST MPGCDA
      CALL MPGCDA (X, Y, Z)
      CALL MPFOUT (Z, DECPL)
C TEST MPGCDB
      CALL MPGCDB (X, Y)
      CALL MPFOUT (X, DECPL)
      CALL MPFOUT (Y, DECPL)
      WRITE (LUN, 220)
  220 FORMAT (/ 44H TEST VARYING DIGITS, BASE AND ROUNDING RULE /)
C SAVE BASE, DIGITS AND ROUNDING INDICATOR, THEN VARY THEM
      CALL MPSAVN (SV)
      JL = MAX0 (2, BASE - 2)
      DO 230 I = 1, 4
      DO 230 J = JL, BASE
C SET BASE TO J
      CALL MPPARB (J, 4HBASE)
C SET NUMBER OF DIGITS TO EQUIVALENT OF AT LEAST 10*I DECIMAL DIGITS
      CALL MPPARB (MPDIGS (10*I), 6HNUMDIG)
      DO 230 K = 1, 4
C SET RNDRL TO K-1
      CALL MPSETR (K-1)
C COMPUTE EXP(PI*SQRT(163))
      CALL MPCAM (2HPI, X)
      CALL MPQPWR (163, 1, 1, 2, Y)
      CALL MPMUL (X, Y, X)
      CALL MPEXP (X, X)
  230 CALL MPFOUT (X, 10*I)
C RESTORE BASE, NUMBER OF DIGITS, AND RNDRL.
      CALL MPRESN (SV)
      WRITE (LUN, 240)
  240 FORMAT (/ 28H TEST OF VARIOUS MP ROUTINES /)
C COMPUTE LN(PI) USING MPLNGS
      CALL MPLNGS (PI, X)
      CALL MPFOUT (X, DECPL)
C COMPUTE PI**E USING MPPWR2
      CALL MPCIM (1, X)
      CALL MPEXP (X, X)
      CALL MPPWR2 (PI, X, X)
      CALL MPFOUT (X, DECPL)
C COMPUTE 2*PI**3 - 4*PI**2 + 3*PI - 1 USING MPPOLY
      CALL MPPOLY (PI, X, J14, 4)
      CALL MPFOUT (X, DECPL)
C CONVERT -PI TO CHARACTER FORMAT USING MPOUT, THEN BACK TO MP
C FORMAT USING MPIN.
      CALL MPNEG (PI, X)
      CALL MPOUT (X, A, DECPL+3, DECPL)
      CALL MPIN (A, X, DECPL+3, ERROR)
C ERROR SHOULD BE FALSE
      IF (ERROR) CALL MPERR
      CALL MPFOUT (X, DECPL)
C X SHOULD BE NEGATIVE (IF NOT, PROBABLE CAUSE IS MINUS AND
C BLANK NOT DISTINGUISHED BY FUNCTION MPIS).
      IF (MPSIGA (X) .GE. 0) CALL MPERR
C NOW TEST MPINE BY FORMING -PI*(10**1234)
      CALL MPINE (A, X, DECPL+3, 1234, ERROR)
      IF (ERROR) CALL MPERR
C EXPONENT WILL PRINT AS E+**
      CALL MPFOUT (X, DECPL)
C TRY AGAIN WITH LARGER EXPONENT FIELD
      CALL MPPARB (6, 5HEXWID)
      CALL MPFOUT (X, DECPL)
C CONVERT PI**3 TO EXPONENT AND SINGLE-PRECISION FRACTION
      CALL MPPWR (PI, 3, X)
      CALL MPCMRE (X, N, RX)
      WRITE (LUN, 250) RX, N
  250 FORMAT (1X, F18.15, I6)
C NOW CONVERT TO EXPONENT AND DOUBLE-PRECISION FRACTION
      CALL MPCMDE (X, N, DX)
      WRITE (LUN, 260) DX, N
  260 FORMAT (1X, F33.30, I6)
C CONVERT BACK TO MULTIPLE-PRECISION
      CALL MPCDM (DX*(10D0**N), X)
C AND PRINT (NUMBER OF PLACES AGREEMENT DEPENDS ON
C FLOATING-POINT FRACTION LENGTH)
      CALL MPFOUT (X, 20)
C COMPUTE INTEGER PART OF PI**80
      CALL MPPWR (PI, 80, X)
      CALL MPCMIM (X, X)
      CALL MPFOUT (X, DECPL)
C DUMP MACHINE-PRECISION, MINREAL AND MAXREAL (THESE DEPEND
C ON BASE AND NUMBER OF DIGITS, AND HENCE ON THE WORDLENGTH
C OF THE MACHINE USED).
      CALL MPCAM (7HEPSILON, X)
      CALL MPDUMP (X)
      CALL MPCAM (7HMINREAL, X)
      CALL MPDUMP (X)
      CALL MPCAM (7HMAXREAL, Y)
      CALL MPDUMP (Y)
C PRINT USING MP40D (Y IS TOO LARGE SO MPOUT GIVES
C ALL ASTERISKS)
      CALL MP40D (DECPL, Y)
C CAUSE AN MP UNDERFLOW (RESULT Z WILL BE SET TO ZERO BY MPUNFL)
      CALL MPPARM (6HKTUNFL, .FALSE., KTU)
      CALL MPMUL (X, X, Z)
      CALL MPFOUT (Z, DECPL)
      CALL MPPARM (6HKTUNFL, .FALSE., KTV)
      KTU = KTV - KTU
C KTU SHOULD BE ONE AS ONE UNDERFLOW SHOULD HAVE OCCURRED.
      IF (KTU.NE.1) CALL MPERR
C MOVE MP PARAMETERS TO LOCAL ARRAY
      DO 270 I = 1, 23
  270 MPC (I) = MPPARN (I)
C AND WRITE THEM
      WRITE (LUN, 280) MPC
  280 FORMAT (/ 33H FINAL CONTENTS OF COMMON /MPCOM/,
     $  5(/1X, 4I16) / 16X, A1, 2I16)
C GET MAXIMUM STACK POINTER
      CALL MPPARM (6HMXSPTR, .FALSE., MXSPTR)
      WRITE (LUN, 290) MXSPTR
  290 FORMAT (/ 19H END OF TEST2, USED, I5,
     $  23H WORDS OF WORKING SPACE /)
      STOP
      END
