C
C Contains VAX-dependent routines (MPLARG and MPUPW),
C when mapping make sure these override 'standard' versions
C in [rpb.mp]f2.for
C
C R. Brent, 840120
C
C $$                   ******  MPLARG  ******
      SUBROUTINE MPLARG (MXINT)
C
C              *************************    (SEE THE MP
C              *** MACHINE DEPENDENT ***     USERS GUIDE FOR
C              *************************     CONVERSION HINTS)
C
C RETURNS MXINT .LE. THE MAXIMUM REPRESENTABLE INTEGER OF
C THE FORM 2**J - 1 .
C
C INTEGER ARITHMETIC MUST BE PERFORMED EXACTLY ON INTEGERS
C IN THE RANGE -MXINT ... +MXINT, SO ON SOME MACHINES
C MXINT MUST BE LESS THAN THE LARGEST REPRESENTABLE INTEGER,
C E.G. THIS APPLIES ON BURROUGHS B6700 AND CYBER 76 SERIES.
C
      LOGICAL CYBER, B6700, PDP11, vax
      INTEGER I, K, MX, MXINT, WDLEN
C
C WDLEN MAY BE SET TO THE WORDLENGTH (IN BITS) IN THE FOLLOWING
C DATA STATEMENT IF THE CODE BELOW FOR COMPUTING MXINT DOES
C NOT WORK.
C
      DATA WDLEN /0/
C
C ON CYBER 76, BURROUGHS 6700, vax OR PDP 11 MACHINES SET
C THE CORRESPONDING LOGICAL VARIABLE TO .TRUE.
C
      DATA CYBER /.FALSE./
      DATA B6700 /.FALSE./
      DATA PDP11 /.FALSE./
      data vax   /.true./
C
C THE FOLLOWING ASSUMES AT LEAST 2 CHARACTERS PER WORD,
C CHARACTERS 0 AND 1 HAVE CONSECUTIVE BINARY CODES, AND
C LEFTMOST CHARACTER IS IN MOST SIGNIFICANT POSITION.
C IF THESE ASSUMPTIONS FAIL, WDLEN (OR ONE OF CYBER, B6700,
C PDP11) MUST BE SET ABOVE.
C
C FOR A LESS RESTRICTIVE ALGORITHM SEE - ALGORITHMS TO REVEAL
C THE REPRESENTATION OF CHARACTERS, INTEGERS AND FLOATING-POINT
C NUMBERS (BY J. E. GEORGE), ACM TRANS. MATH. SOFTWARE 1(1975),
C 210-216.  UNLIKE GEORGE, WE AVOID THE USE OF AN EXTERNAL UNIT.
C
      K = WDLEN
      IF (CYBER) K = 49
      IF (B6700) K = 40
      IF (PDP11) K = 16
      if (vax) k = 32
      IF (K .GT. 0) GO TO 10
C HERE TRY TO COMPUTE LOWER BOUND ON MXINT.
      CALL MPSUBA (2H10, 2H00, MXINT)
      CALL MPSUBA (2H01, 2H00, MX)
      MXINT = 2*(MXINT*(MXINT/(4*MX)) - 1) + 1
      RETURN
C HERE K IS LOWER BOUND ON WORDLENGTH, COMPUTE 2**(K-1) - 1
   10 MXINT = 0
      DO 20 I = 2, K
   20 MXINT = 2*MXINT + 1
      RETURN
      END
	subroutine mpupw (w, c, n)
	integer w, c(4)
	n = 4
	decode (n, 10, w) c
10	format (80a1)
	return
	end
